/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.scoreboard;

import com.google.common.base.Suppliers;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentContainer;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.scoreboard.ScoreboardComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.scoreboard.ScoreboardComponentFactoryV2;
import dev.onyxstudios.cca.api.v3.scoreboard.ScoreboardComponentInitializer;
import dev.onyxstudios.cca.api.v3.scoreboard.TeamComponentFactoryV2;
import dev.onyxstudios.cca.internal.base.GenericContainerBuilder;
import dev.onyxstudios.cca.internal.base.LazyDispatcher;
import dev.onyxstudios.cca.internal.base.asm.StaticComponentPluginBase;
import dev.onyxstudios.cca.internal.scoreboard.ScoreboardComponentContainerFactory;
import dev.onyxstudios.cca.internal.scoreboard.TeamComponentContainerFactory;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.server.MinecraftServer;

public final class StaticScoreboardComponentPlugin
extends LazyDispatcher
implements ScoreboardComponentFactoryRegistry {
    public static final StaticScoreboardComponentPlugin INSTANCE = new StaticScoreboardComponentPlugin();
    public static final Supplier<ScoreboardComponentContainerFactory> scoreboardComponentsContainerFactory = Suppliers.memoize(INSTANCE::buildScoreboardContainerFactory);
    public static final Supplier<TeamComponentContainerFactory> teamComponentsContainerFactory = Suppliers.memoize(INSTANCE::buildTeamContainerFactory);
    private final GenericContainerBuilder<ScoreboardComponentFactoryV2<?>, ScoreboardComponentContainerFactory> scoreboardFactories = new GenericContainerBuilder(ScoreboardComponentFactoryV2.class, ScoreboardComponentContainerFactory.class, List.of(class_269.class, MinecraftServer.class), (scoreboard, server) -> ComponentContainer.EMPTY);
    private final GenericContainerBuilder<TeamComponentFactoryV2<?>, TeamComponentContainerFactory> teamFactories = new GenericContainerBuilder(TeamComponentFactoryV2.class, TeamComponentContainerFactory.class, List.of(class_268.class, class_269.class, MinecraftServer.class), (team, scoreboard, server) -> ComponentContainer.EMPTY);

    private ScoreboardComponentContainerFactory buildScoreboardContainerFactory() {
        this.ensureInitialized();
        return (ScoreboardComponentContainerFactory)this.scoreboardFactories.factoryNameSuffix("ScoreboardImpl").build();
    }

    private TeamComponentContainerFactory buildTeamContainerFactory() {
        this.ensureInitialized();
        return (TeamComponentContainerFactory)this.teamFactories.factoryNameSuffix("TeamImpl").build();
    }

    private StaticScoreboardComponentPlugin() {
        super("made a scoreboard");
    }

    protected void init() {
        StaticComponentPluginBase.processInitializers((Collection)StaticComponentPluginBase.getComponentEntrypoints((String)"cardinal-components-scoreboard", ScoreboardComponentInitializer.class), initializer -> initializer.registerScoreboardComponentFactories(this));
    }

    @Override
    public <C extends Component> void registerScoreboardComponent(ComponentKey<C> type, ScoreboardComponentFactoryV2<? extends C> factory) {
        this.registerScoreboardComponent(type, type.getComponentClass(), factory);
    }

    @Override
    public <C extends Component> void registerScoreboardComponent(ComponentKey<? super C> type, Class<C> impl, ScoreboardComponentFactoryV2<? extends C> factory) {
        this.checkLoading(ScoreboardComponentFactoryRegistry.class, "registerForScoreboards");
        this.scoreboardFactories.component(type, impl, factory, Set.of());
    }

    @Override
    public <C extends Component> void registerTeamComponent(ComponentKey<C> type, TeamComponentFactoryV2<? extends C> factory) {
        this.registerTeamComponent(type, type.getComponentClass(), factory);
    }

    @Override
    public <C extends Component> void registerTeamComponent(ComponentKey<? super C> type, Class<C> impl, TeamComponentFactoryV2<? extends C> factory) {
        this.checkLoading(ScoreboardComponentFactoryRegistry.class, "register");
        this.teamFactories.component(type, impl, factory, Set.of());
    }
}

